% Matlab routine to transform stresses exported from Ansys into MultiFat format "*.nds"

sa1 = dlmread('LC3.txt','\t', 1, 0);
sa2 = dlmread('LC4.txt','\t', 1, 0);
sa3 = dlmread('LC5.txt','\t', 1, 0);
sa4 = dlmread('LC7.txt','\t', 1, 0);
sa5 = dlmread('LC9.txt','\t', 1, 0);
sa6 = dlmread('LC10.txt','\t', 1, 0);
sa7 = dlmread('LC12.txt','\t', 1, 0);
sa8 = dlmread('LC17.txt','\t', 1, 0);
%sa7 = dlmread('LC7.txt','\t', 1, 0);

nnd2 = size(sa1); 
nnd = nnd2(1)

idmat = 1001*ones(nnd,1);

% if the stresses have been exported directly from LC's
sa2 = [sa2(:,1),sa2(:,2:7)-sa1(:,2:7)];
sa3 = [sa3(:,1),sa3(:,2:7)-sa1(:,2:7)];
sa4 = [sa4(:,1),sa4(:,2:7)-sa1(:,2:7)];
sa5 = [sa5(:,1),sa5(:,2:7)-sa1(:,2:7)];
sa6 = [sa6(:,1),sa6(:,2:7)-sa1(:,2:7)];
sa7 = [sa7(:,1),sa7(:,2:7)-sa1(:,2:7)];
sa8 = [sa8(:,1),sa8(:,2:7)-sa1(:,2:7)];

%sa7 = [sa7(:,1),sa7(:,2:7)-sa1(:,2:7)];

sa1 = [sa1(:,1),idmat,sa1(:,2:7)];
sa2 = [sa2(:,1),idmat,sa2(:,2:7)];
sa3 = [sa3(:,1),idmat,sa3(:,2:7)];
sa4 = [sa4(:,1),idmat,sa4(:,2:7)];
sa5 = [sa5(:,1),idmat,sa5(:,2:7)];
sa6 = [sa6(:,1),idmat,sa6(:,2:7)];
sa7 = [sa7(:,1),idmat,sa7(:,2:7)];
sa8 = [sa8(:,1),idmat,sa8(:,2:7)];
%sa7 = [sa7(:,1),idmat,sa7(:,2:7)];

% if the stresses have been exported as Linear Combinations differences with the LC1 preload
%sa1 = [sa1(:,1),idmat,sa1(:,2:7)];
%sa2 = [sa2(:,1),idmat,sa2(:,2:7)];
%sa3 = [sa3(:,1),idmat,sa3(:,2:7)];
%sa4 = [sa4(:,1),idmat,sa4(:,2:7)];
%sa5 = [sa5(:,1),idmat,sa5(:,2:7)];
%sa6 = [sa6(:,1),idmat,sa6(:,2:7)];
%sa7 = [sa7(:,1),idmat,sa7(:,2:7)];

%samf = [sa1; sa2; sa3; sa4; sa5; sa6; sa7];
samf = [sa1; sa2; sa3; sa4; sa5; sa6; sa7; sa8];

save fatigue.nds samf -ascii

